<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class BeemService
{
    public function sendSms($to, $message)
    {
        $response = Http::withBasicAuth(env('BEEM_API_KEY'), env('BEEM_SECRET_KEY'))
            ->post('https://sms.beem.africa/v1/send', [
                'source_addr' => env('BEEM_SENDER_ID', 'INFO'),
                'encoding' => 0,
                'schedule_time' => '',
                'message' => $message,
                'recipients' => [
                    ['recipient_id' => '1', 'dest_addr' => $to]
                ]
            ]);

        if ($response->successful()) {
            return true;
        }

        // Log any errors
        logger()->error('Beem SMS failed', [
            'status' => $response->status(),
            'body' => $response->body()
        ]);

        return false;
    }
}
