<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Car Care | Book Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', sans-serif;
            color: #333;
            padding: 20px;
        }

        h2 {
            text-align: center;
            color: #007bff;
            font-weight: bold;
            margin-bottom: 30px;
        }

        .form-container {
            background: #fff;
            border-radius: 15px;
            padding: 30px;
            max-width: 720px;
            margin: auto;
            box-shadow: 0 4px 15px rgba(0, 123, 255, 0.15);
        }

        label {
            font-weight: 600;
            color: #333;
        }

        .form-control, textarea {
            border-radius: 8px;
            background-color: #f9f9f9;
            border: 1px solid #ccc;
        }

        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 6px rgba(0, 123, 255, 0.4);
        }

        .form-check-input:checked {
            background-color: #007bff;
            border-color: #007bff;
        }

        .btn-custom {
            background-color: #007bff;
            color: #fff;
            border: none;
            font-weight: 600;
            border-radius: 8px;
            padding: 12px 30px;
            transition: 0.3s ease;
        }

        .btn-custom:hover {
            background-color: #0056b3;
        }

        .alert {
            max-width: 720px;
            margin: 20px auto;
        }
    </style>
</head>
<body>

    <h2><i class="fas fa-calendar-check"></i> Book Your Car Service</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="form-container">
        <form action="{{ route('booking.store') }}" method="POST">
            @csrf

            <div class="mb-3">
                <label for="customer_name">Full Name</label>
                <input type="text" name="customer_name" id="customer_name" class="form-control" required>
            </div>

            <div class="mb-3">
                <label for="customer_phone">Phone Number</label>
                <input type="text" name="customer_phone" id="customer_phone" class="form-control" required>
            </div>

            <div class="mb-3">
                <label for="customer_address">Home Address</label>
                <textarea name="customer_address" id="customer_address" class="form-control" rows="2" required></textarea>
            </div>

            <div class="mb-3">
                <label for="preferred_date">Preferred Date</label>
                <input type="date" name="preferred_date" id="preferred_date" class="form-control" required>
            </div>

            <div class="mb-3">
                <label>Select Services</label>
                @php
                    $services = [
                        'Engine Oil Change',
                        'Gear Box Oil Change',
                        'Brake Pads Change',
                        'Puncture Tire Fix',
                        'Tire Change'
                    ];
                @endphp
                @foreach($services as $service)
                    <div class="form-check mb-2">
                        <input type="checkbox" name="services[]" value="{{ $service }}" class="form-check-input" id="{{ \Illuminate\Support\Str::slug($service) }}">
                        <label class="form-check-label" for="{{ \Illuminate\Support\Str::slug($service) }}">{{ $service }}</label>
                    </div>
                @endforeach
            </div>

            <div class="text-center mt-4">
                <button type="submit" class="btn btn-custom"><i class="fas fa-paper-plane"></i> Book Now</button> 
            </div>
        </form>
    </div>

</body>
</html>
